//
//  FFAsset.h
//  PlayNiceX
//
//  Created by Jörgen Isaksson on 2012-11-22.
//  Copyright (c) 2012 Bitfield AB. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "avformat.h"

#import "FFTrack.h"
#import "FFSubtitleItem.h"

#import "VDKQueue.h"

#define kStyleBold 1
#define kStyleItalic 2
#define kStyleUnderlined 4
#define kStyleColor 8

#define kTagOpen 1
#define kTagClose 2

typedef struct rgbaColor {
    u_int8_t r;
    u_int8_t g;
    u_int8_t b;
    u_int8_t a;
} rgbaColor;

typedef struct styleRecord {
    uint16_t startChar;
    uint16_t endChar;
    uint16_t fontID;
    uint8_t  fontStyles;
    uint8_t  fontSize;
    rgbaColor color;
} styleRecord;

typedef NS_ENUM(NSInteger, FFAssetStatus) {
    FFAssetStatusUnknown,
    FFAssetStatusReadyToPlay,
    FFAssetStatusFailed
};

@protocol FFAssetDelegate <NSObject>

@optional
- (void)subtitleFileChanged:(NSString *)path;
- (void)audioEngineConfigurationChanged:(FFAudioTrack *)audioTrack;

@end

@interface FFAsset : NSObject <VDKQueueDelegate>
{
    NSDictionary        *_info;
    float               _volume;
}

@property (weak) id <FFAssetDelegate> delegate;

@property (nonatomic, strong) AVPlayer *avPlayer;

@property (nonatomic, readonly) FFAssetStatus status;
@property (nonatomic, readonly) NSError *error;

@property (assign) AVFormatContext *formatContext;
@property (nonatomic, strong) FFVideoTrack *currentVideoTrack;
@property (nonatomic, strong) FFAudioTrack *currentAudioTrack;
@property (nonatomic, strong) FFSubtitleTrack *currentSubtitleTrack;
@property (assign) CMTime duration;

@property (nonatomic, strong) NSURL *url;
@property (strong) NSMutableArray *tracks;
@property (strong) NSMutableArray *videoTracks;
@property (strong) NSMutableArray *audioTracks;
@property (strong) NSMutableArray *subtitleTracks;

@property (readonly, nonatomic, strong) NSDictionary *info;

@property (nonatomic, assign) float volume;

@property (strong) NSMutableDictionary *metadataDictionary;
@property (strong) NSMutableArray *chaptersArray;

@property (strong) VDKQueue *fileWatcherQueue;


- (id)initWithURL:(NSURL*)url error:(NSError **)outError;

- (void)parseEmbeddedSubtitlesInPlayerView:(FFPlayerLayerView *)playerView;

- (void)selectPreferredSubtitleTrack;

// Utilities
NSString* StripSSALine(NSString *line);

- (CGSize)naturalSize;

// Getter/Setter
- (void)setVolume:(float)newVolume;
- (float)volume;

- (void)handleInterruption:(NSNotification *)notif;

@end
