//
//  FFExportPreset.h
//
//  Created by Jörgen Isaksson on 2014-03-14
//  Copyright (c) 2014 Bitfield AB. All rights reserved.
//

#import <Foundation/Foundation.h>



@interface FFExportPreset : NSObject <NSCoding>

@property (nonatomic, strong) NSString *audioBitrate;
@property (nonatomic, strong) NSString *profile;
@property (nonatomic, strong) NSString *audioCodec;
@property (nonatomic, strong) NSString *audioSampleRate;
@property (nonatomic, strong) NSString *maxHeight;
@property (nonatomic, assign) BOOL supportsAC3Passthrough;
@property (nonatomic, strong) NSString *crf;
@property (nonatomic, assign) double maxWidth;
@property (nonatomic, strong) NSString *desc;
@property (nonatomic, assign) double level;
@property (nonatomic, strong) NSString *identifier;
@property (nonatomic, strong) NSString *videoCodec;
@property (nonatomic, strong) NSString *extension;
@property (nonatomic, assign) BOOL supportsSoftSubtitles;
@property (nonatomic, strong) NSString *name;
@property (nonatomic, assign) double audioChannels;

+ (FFExportPreset *)modelObjectWithDictionary:(NSDictionary *)dict;
- (instancetype)initWithDictionary:(NSDictionary *)dict;
- (NSDictionary *)dictionaryRepresentation;

@end
