//
//  FFPlayerLayerView.h
//  PlayNiceX
//
//  Created by Jörgen Isaksson on 2013-02-01.
//  Copyright (c) 2013 Bitfield AB. All rights reserved.
//

#import <AVFoundation/AVFoundation.h>

#import "FFAsset.h"
#import "FFSynchronizedLayer.h"
#import "FFTextLayer.h"
#import "FFChapterItem.h"
#import "FFSampleBufferDisplayLayer.h"
#import "FFStringBoundsOperation.h"

#define MIN_BRIGHTNESS     -1.0
#define MAX_BRIGHTNESS     +1.0
#define DEFAULT_BRIGHTNESS  0.0

#define MIN_SATURATION      0.0
#define MAX_SATURATION      2.0
#define DEFAULT_SATURATION  1.0

#define MIN_CONTRAST        0.0
#define MAX_CONTRAST        2.0
#define DEFAULT_CONTRAST    1.0

#define MIN_HUE            -3.14
#define MAX_HUE            +3.14
#define DEFAULT_HUE         0.0

#define adjustToRange(value, minValue, maxValue)    MIN(MAX((minValue), (value)), (maxValue))

#define USE_AVSAMPLEBUFFERDISPLAYLAYER 1

@class FFSampleBufferDisplayLayer;

@interface FFPlayerLayerView : NSView <FFStringBoundsOperationDelegate, FFAssetDelegate>
{
    CMTimebaseRef       _masterTimebase;
    dispatch_queue_t    _decodingQueue;
    dispatch_queue_t    _subtitlesQueue;
}

#ifdef USE_AVSAMPLEBUFFERDISPLAYLAYER
@property (nonatomic, strong) AVSampleBufferDisplayLayer *videoLayer;
@property (nonatomic, strong) AVPlayerLayer *playerLayer;
#else
@property (nonatomic, strong) FFSampleBufferDisplayLayer *videoLayer;
#endif

@property (nonatomic, strong) FFAsset *asset;
@property (nonatomic, strong) FFSynchronizedLayer *syncLayer;
@property (nonatomic, strong) FFTextLayer *subtitleLayer;
@property (strong) NSOperationQueue *stringBoundsOperationQueue;
@property (assign) BOOL firstFrame;

@property (assign, nonatomic) BOOL useRelativeFontSize; // does subtitles scale in relation to the height of the player view
@property (assign, nonatomic) BOOL useTitleSafeArea; // are subtitles constrained to the syncLayer's bounds
@property (assign, nonatomic) CGFloat titleSafeAreaVerticalSpacingPercent;
@property (assign, nonatomic) CGFloat titleSafeAreaHorizontalSpacingPercent;

- (void)setAsset:(FFAsset *)asset;
- (void)changeAsset:(FFAsset *)newAsset;

- (void)flushRenderQueue;

- (void)readFrames;

- (void)resetSyncLayerBounds;

- (void)setupSubtitleLayer;
- (void)removeSubtitleLayer;

- (double)currentTime;
- (CMTime)currentCMTime;
- (float)rate;
- (void)setRate:(float)rate;

- (void)scrubDidEnd;
- (void)seekToTime:(CMTime)timeToSeekTo;
- (void)previewSeekToTime:(CMTime)timeToSeekTo;

- (void)gotoEnd;
- (void)gotoBeginning;
- (void)gotoChapter:(FFChapterItem *)chapter;
- (void)skipBack15Seconds;
- (void)skipBack10Seconds;
- (void)skipForward10Seconds;

- (void)stepForward;
- (void)stepBackward;

- (IBAction)togglePlayPause:(id)sender;
- (IBAction)pause:(id)sender;
- (IBAction)play:(id)sender;

- (void)handleTitleSafeAreaPreview;

- (NSImage *)currentFrameImage;

- (void)setBrightness:(CGFloat)brightness;
- (CGFloat)brightness;

- (void)setSaturation:(CGFloat)saturation;
- (CGFloat)saturation;

- (void)setContrast:(CGFloat)contrast;
- (float)contrast;

- (void)setHue:(CGFloat)hue;
- (float)hue;

- (NSSize)videoSizeInLayer;

@end
