//
//  FFPlayerGLLayer.h
//  PlayNiceX
//
//  Created by Jörgen Isaksson on 2013-02-19.
//  Copyright (c) 2013 Bitfield AB. All rights reserved.
//

#import <QuartzCore/QuartzCore.h>
#import <CoreMedia/CoreMedia.h>

#import "avformat.h"

@interface FFSampleBufferDisplayLayer : CAOpenGLLayer
{
@private
    CMBufferQueueRef videoBufferQueue;

	CVOpenGLTextureRef currentFrame;
    CVOpenGLTextureCacheRef textureCache;
    
    dispatch_block_t _enqueueBlock;
    dispatch_queue_t _enqueueQueue;
    
    CGRect textureRect;
    CGFloat imageAspectRatio;
}

@property (retain) __attribute__((NSObject)) CMTimebaseRef controlTimebase;
@property(copy) NSString *videoGravity;
@property (readwrite,nonatomic,copy) dispatch_block_t enqueueBlock;
@property (readwrite,nonatomic,copy) dispatch_queue_t enqueueQueue;

@property (assign) NSInteger frameWidth;
@property (assign) NSInteger frameHeight;

@property (assign) BOOL didDisplayCurrentFrame;
@property (assign) BOOL stopped;

- (void)invalidate:(NSNotification*)inNotification;

- (BOOL)isNewImageAvailable;

- (void)requestMoreFrames;

- (void)enqueueSampleBuffer:(CMSampleBufferRef)sampleBuffer;
- (void)flush;
- (void)flushAndRemoveImage;
@property (readonly, getter=isReadyForMoreMediaData) BOOL readyForMoreMediaData;
- (void)requestMediaDataWhenReadyOnQueue:(dispatch_queue_t)queue usingBlock:(void (^)(void))block;
- (void)stopRequestingMediaData;

- (NSRect)fitRect:(NSRect)rect inRect:(NSRect)dest;

@end
