//
//  FFSubtitleItem.h
//  PlayNiceX
//
//  Created by Jörgen Isaksson on 2013-04-11.
//  Copyright (c) 2013 Bitfield AB. All rights reserved.
//

#import <Foundation/Foundation.h>

#define STYLE_BOLD 1
#define STYLE_ITALIC 2
#define STYLE_UNDERLINED 4
#define STYLE_COLOR 8

typedef struct rgba_color {
    u_int8_t r;
    u_int8_t g;
    u_int8_t b;
    u_int8_t a;
} rgba_color;

@interface FFSubtitleItem : NSObject <NSSecureCoding>
{
}

@property (strong) NSString *line;
@property (strong) NSAttributedString *attributedLine;
@property (assign) CGFloat begin_time; // in seconds
@property (assign) CGFloat end_time; // in seconds
@property (assign) BOOL forced;

// Text position: T:[number]%
@property (strong) NSNumber *horizontalTextPosition; // 0.0 -> 0.1

// Line position: L:[number]%
@property (strong) NSNumber *verticalTextPosition;  // 0.0 -> 0.1

// Specifies the alignment of the text.
// align:[start|middle|end]
@property (strong) NSString *alignmentMode;

- (id)initWithLine:(NSString*)l start:(CGFloat)s end:(CGFloat)e;

- (CMFormatDescriptionRef)formatDescription;
- (CMSampleBufferRef)subtitleSampleBuffer; // for AVAssetWriter and MP4v2 Lib

@end
