//
//  FFSubtitleStyle.h
//  LibAVFoundation
//
//  Created by Jörgen Isaksson on 2013-09-27.
//  Copyright (c) 2013 Bitfield AB. All rights reserved.
//

#import <Foundation/Foundation.h>

typedef enum _SubtitleFontSize {
	kSubtitleFontSize_ExtraSmall = 18,
	kSubtitleFontSize_Small = 24,
	kSubtitleFontSize_Medium = 30,
	kSubtitleFontSize_Large = 36,
	kSubtitleFontSize_ExtraLarge = 42,
    kSubtitleFontSize_VeryLarge = 48
} SubtitleFontSize;

typedef enum _SubtitleTextAlignment {
    kSubtitleTextAlignment_Left = 0,
    kSubtitleTextAlignment_Center = 1,
    kSubtitleTextAlignment_Right = 2
} SubtitleTextAlignment;


@interface FFSubtitleStyle : NSObject
{
    NSArray *_fontSizeNames;
}
    
@property (strong) NSString *uid;
@property (strong) NSString *name;
@property (strong) NSString *fontName;
@property (assign) CGFloat fontSize;
@property (strong) NSColor *fontColor;
@property (assign) BOOL plate;
@property (strong) NSColor *plateColor;
@property (assign, nonatomic) CGFloat plateOpacity;
@property (assign) BOOL shadow;
@property (strong) NSColor *shadowColor;
@property CGSize shadowOffset;
@property (assign) CGFloat shadowBlur;
@property (assign) CGFloat shadowOpacity;
@property (assign) CGFloat shadowRadius;
@property (assign) CGFloat cornerRadius;
@property (assign) NSUInteger alignmentMode;

+ (FFSubtitleStyle *)defaultSubtitleStyle;
+ (FFSubtitleStyle *)classicSubtitleStyle;

- (CGFloat)shadowLength;
- (void)setShadowLength:(CGFloat)length;

- (CGFloat)shadowAngle;
- (void)setShadowAngle:(CGFloat)angle;

- (CGFloat)scaleFactor;

@end
