//
//  FFTrack.h
//  PlayNiceX
//
//  Created by Jörgen Isaksson on 2012-11-22.
//  Copyright (c) 2012 Bitfield AB. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <Accelerate/Accelerate.h>
#import <AVFoundation/AVFoundation.h>
#ifdef __MAC_OS_X_VERSION_MAX_ALLOWED
#import <VideoDecodeAcceleration/VDADecoder.h> // only on mac os x
#import <VideoToolbox/VideoToolbox.h>
#endif
#import "avformat.h"
#import "swscale.h"
#import "swresample.h"
#import "videotoolbox.h"

#import "FFSubtitleStyle.h"
#import "FFSynchronizedLayer.h"

@class FFPlayerLayerView;

@interface FFTrack : NSObject
{
}
@property (assign) int                          streamIndex;
@property (assign) AVStream                     *stream;
@property (assign) AVCodecContext               *codecContext;
@property (assign) AVCodec                      *codec;
@property (assign) AVFrame                      *frame; // for decoding
@property (assign) CGFloat                      timebase;
@property (assign) CGFloat                      fps;
@property (nonatomic, strong) NSString          *languageCode;
@property (nonatomic, strong) NSString          *language;
@property (nonatomic, strong) NSMutableArray    *chaptersArray;
@property (nonatomic, readonly) NSString        *kind;

- (id)initWithAVStream:(AVStream *)s error:(NSError **)outError;
- (void)calculateStreamFPSTimeBase:(AVStream *)st defaultTimeBase:(float)defaultTimeBase pFPS:(CGFloat *)pFPS pTimeBase:(CGFloat *)pTimeBase;
- (BOOL)setupCodec:(NSError **)outError;

@end

// VIDEO

@interface FFVideoTrack : FFTrack
{
}
@property (assign) CMSampleBufferRef decodedSampleBuffer;
@property (assign) VTDecompressionSessionRef hardwareDecompressionSession;
#ifdef __MAC_OS_X_VERSION_MAX_ALLOWED
@property (assign) VDADecoder hardwareDecoder;
#else
@property (assign) id hardwareDecoder;
#endif
@property (strong) NSNumber *pixelFormat;
@property (assign) int outputWidth;
@property (assign) int outputHeight;
//@property (assign) AVPicture picture;
@property (assign) struct SwsContext *img_convert_ctx;
@property (assign) int profile;
@property (strong) NSString *profileName;
@property (assign) int level;
@property (assign) BOOL usingAVPlayer;

- (void)setupScaler;
- (void)setupHardwareDecoder;
- (CMSampleBufferRef)decodeVideoPacket:(AVPacket*)packet;
- (CMSampleBufferRef)hardwareDecompressVideoPacket:(AVPacket*)packet;
- (CGFloat)fps;
- (NSString *)decoderDescription;

@end

// AUDIO

@interface FFAudioTrack : FFTrack
{
}
@property (nonatomic, assign) float volume;
@property (assign) BOOL syncNextBuffer;
@property (assign) BOOL videoUsingHardwareDecoder;
@property (assign) struct SwrContext *audio_convert_ctx;
@property (assign) Float64 timeOffset;
@property (assign) int numInputChannels;
@property (assign) UInt32 numOutputChannels;
@property (strong) AVAudioFormat *audioOutputFormat;
@property (strong) AVAudioEngine *audioEngine;
@property (strong) AVAudioPlayerNode *audioPlayer;
@property (strong) NSMutableArray *audioBuffersArray;
@property (strong) AVAudioTime *audioBufferStartTime;
@property (assign) NSUInteger audioBufferIndex;
@property (assign) NSUInteger largestNumSamplesDecoded;

- (void)setupAudioTrack;
- (void)setupAudioEngine;
- (void)setupAudioBuffers;
- (void)play;
- (void)pause;
- (void)stop;
- (void)scrub:(CMTimebaseRef)timebase;
- (void)decodeAudioPacket:(AVPacket *)packet;
- (AVAudioTime *)decodeAudioPacket:(AVPacket *)packet inBuffer:(AVAudioPCMBuffer *)buffer;

@end

// SUBTITLE

@interface FFSubtitleTrack : FFTrack
{
}
@property (strong) FFSubtitleStyle *subtitleStyle;
@property (strong) NSString *filePath;
@property (strong) NSArray *subtitlesArray;
@property (assign) NSStringEncoding encoding;
@property (assign) BOOL embedded;
@property (assign) BOOL loading;

- (void)setupSubtitleStyleFromPreferences;
- (NSArray *)metadata;
- (NSString *)languageCodeISO6392;
- (IBAction)revealInFinder:(id)sender;
- (IBAction)exportToSRT:(id)sender;
- (IBAction)exportTo3GPP:(id)sender;
- (IBAction)exportToWebVTT:(id)sender;
- (IBAction)exportToSTL:(id)sender;
- (IBAction)exportToITT:(id)sender;

@end

