/* 
 This file was generated by Dashcode.  
 You may edit this file to customize your widget or web page 
 according to the license.txt file included in the project.
 */
 
var languages = [];
var timestamp;
var command;
var s;

 // Dynamically load the Translate API
document.write('<script type="text/javascript" src="http://www.google.com/jsapi"></script>');
document.write('<script type="text/javascript">google.load("language", "1");</script>');

//
// Function: load()
// Called by HTML body element's onload event when the widget is ready to start
//
function load()
{
    dashcode.setupParts();
    
    // Preference code
    timestamp = widget.preferenceForKey("timestamp");
    if (!timestamp) {
        widget.setPreferenceForKey(String(Number(new Date())),"timestamp");
        timestamp = widget.preferenceForKey("timestamp");
    }
    
    initTranslate(); 
}

function initTranslate()
{
    var src = document.getElementById('popupFrom');
    var dst = document.getElementById('popupTo');
      
    var i=0;
     
    for (l in google.language.Languages) {
        var lng = l.toLowerCase();
        var lngCode = google.language.Languages[l];
        if (google.language.isTranslatable(lngCode)) {
            var lang = [];
            lang[0] = lng;
            lang[1] = lngCode;
            languages[i] = lang;
            i++;
        }
    } 

    src.object.setOptions(languages);
    dst.object.setOptions(languages);

    var preferenceForFromIndexKey = "fromIndex";
    preferenceForFromIndexKey = widget.preferenceForKey(timestamp + "-" + preferenceForFromIndexKey);
    document.getElementById("popupFrom").object.setSelectedIndex(preferenceForFromIndexKey);
    
     var preferenceForToIndexKey = "toIndex";
    preferenceForToIndexKey = widget.preferenceForKey(timestamp + "-" + preferenceForToIndexKey);
    document.getElementById("popupTo").object.setSelectedIndex(preferenceForToIndexKey);
}

//
// Function: remove()
// Called when the widget has been removed from the Dashboard
//
function remove()
{
    // Stop any timers to prevent CPU usage
    // Remove any preferences as needed
    // widget.setPreferenceForKey(null, dashcode.createInstancePreferenceKey("your-key"));
}

//
// Function: hide()
// Called when the widget has been hidden
//
function hide()
{
    // Stop any timers to prevent CPU usage
}

//
// Function: show()
// Called when the widget has been shown
//
function show()
{
    // Restart any timers that were stopped on hide
}

//
// Function: sync()
// Called when the widget has been synchronized with .Mac
//
function sync()
{
    // Retrieve any preference values that you need to be synchronized here
    // Use this for an instance key's value:
    // instancePreferenceValue = widget.preferenceForKey(null, dashcode.createInstancePreferenceKey("your-key"));
    //
    // Or this for global key's value:
    // globalPreferenceValue = widget.preferenceForKey(null, "your-key");
}

//
// Function: showBack(event)
// Called when the info button is clicked to show the back of the widget
//
// event: onClick event from the info button
//
function showBack(event)
{
    var front = document.getElementById("front");
    var back = document.getElementById("back");

    if (window.widget) {
        widget.prepareForTransition("ToBack");
    }

    front.style.display = "none";
    back.style.display = "block";

    if (window.widget) {
        setTimeout('widget.performTransition();', 0);
    }
}

//
// Function: showFront(event)
// Called when the done button is clicked from the back of the widget
//
// event: onClick event from the done button
//
function showFront(event)
{
    var front = document.getElementById("front");
    var back = document.getElementById("back");

    if (window.widget) {
        widget.prepareForTransition("ToFront");
    }

    front.style.display="block";
    back.style.display="none";

    if (window.widget) {
        setTimeout('widget.performTransition();', 0);
    }
}

if (window.widget) {
    widget.onremove = remove;
    widget.onhide = hide;
    widget.onshow = show;
    widget.onsync = sync;
}


function doTranslate(event)
{
    var textToTranslate = document.getElementById("textToTranslate");
    var translatedText = document.getElementById("translatedText");
    var chosenFrom = document.getElementById("popupFrom").object.getSelectedIndex();
    var chosenTo = document.getElementById("popupTo").object.getSelectedIndex();
    
    var fromLangCode = languages[chosenFrom][1];
    var toLangCode = languages[chosenTo][1];
        
    google.language.translate(textToTranslate.value, fromLangCode, toLangCode, function(result) {
        if (!result.error) {
            translatedText.value = result.translation;
        }
    });
}


function saveFrom(event)
{
    var chosenFrom = document.getElementById("popupFrom").object.getSelectedIndex();

    var preferenceKey = "fromIndex";
    var preferenceValue = chosenFrom;

    // Preference code
    widget.setPreferenceForKey(preferenceValue, timestamp + "-" + preferenceKey);
}


function saveTo(event)
{
     var chosenTo = document.getElementById("popupTo").object.getSelectedIndex();

    var preferenceKey = "toIndex";
    var preferenceValue = event.srcElement.selectedIndex;

    // Preference code
    widget.setPreferenceForKey(preferenceValue, timestamp + "-" + preferenceKey);
}


function copyResult(event)
{
    var translatedText = document.getElementById("translatedText");
	var dataForPasteboard = translatedText.value;

	// Copy code
	event.clipboardData.setData('text/plain', dataForPasteboard);
	event.preventDefault();
	event.stopPropagation();
}


function gotoBitfield(event)
{
    var websiteURL = "http://www.bitfield.se/";
    
    widget.openURL(websiteURL);
}


function swapLanguage(event)
{
    var chosenFrom = document.getElementById("popupFrom").object.getSelectedIndex();
    var chosenTo = document.getElementById("popupTo").object.getSelectedIndex();

    document.getElementById("popupFrom").object.setSelectedIndex(chosenTo);
    document.getElementById("popupTo").object.setSelectedIndex(chosenFrom);
    
    document.getElementById("textToTranslate").value = document.getElementById("translatedText").value;
    
    doTranslate();

}


function avoidTyping(event)
{
    // Insert Code Here
}


function gotoGoogle(event)
{
    var websiteURL = "http://translate.google.com/";
    
    widget.openURL(websiteURL);
}

function copyToClipboard(event)
{
    s = document.getElementById("translatedText").value;
    
    command = widget.system("/bin/echo -n '"+s+"' | /usr/bin/pbcopy", commandDone);
}

function commandDone(cmd)
{
    alert(s);
}